//
//  BIAppVersioning.h
//  BISubstrate
//
//  Created by Michael Clark on 09-10-12.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum {
    BILLINGS_INVALID_VERSION = 0,
    BILLINGS_SINGLE_VERSION  = 1,
    BILLINGS_PRO_VERSION     = 2
} BIAppVersionType;

extern BOOL IS_BILLINGS_SINGLE();
extern BOOL IS_BILLINGS_PRO();

extern BIAppVersionType BILLINGS_APP_VERSION();

#ifdef BILLINGS_PRO
#define BL_SUPER_CLASSNAME_PREFIX _BP
#else
#define BL_SUPER_CLASSNAME_PREFIX _BI
#endif

#define BL_SUPER_CLASSNAME_MUNGE_2(c,d) c ## d
#define BL_SUPER_CLASSNAME_MUNGE_1(a,b) BL_SUPER_CLASSNAME_MUNGE_2(a,b)
#define BL_SUPER_CLASSNAME_MUNGE(x) BL_SUPER_CLASSNAME_MUNGE_1(BL_SUPER_CLASSNAME_PREFIX, x)

